<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Request;
use Illuminate\View\Component;

class SidebarNavigation extends Component
{
    public $items;
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $this->items = config('adminlte.menu');
    }

    public function isAllowed($item): bool
    {
        $user_has_permission = auth()->user()->hasRole('Super Admin') || auth()->user()->hasAnyPermission($item);
        $allowed = in_array('dashboard', $item) ? true : ($user_has_permission ? true : false);
        return $allowed;
    }

    public function isOpen($item): bool
    {
        $isOpen = Request::routeIs($item) ? true : false;
        return $isOpen;
    }

    public function isActive($item): bool
    {
        $isActive = Request::routeIs($item) ? true : false;
        return $isActive;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.sidebar.sidebar-navigation');
    }
}